/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.interactive;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.util.ModelUtils;
import xfacthd.framedblocks.api.util.Utils;

public class FramedWallHangingSignModel
extends FramedBlockModel {
    private final Direction dir;

    public FramedWallHangingSignModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadDir = quad.m_111306_();
        if (quadDir.m_122434_() == this.dir.m_122434_()) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(false, 0.625f)).apply(Modifiers.cutSideLeftRight(0.9375f)).apply(Modifiers.setPosition(0.5625f)).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(true, 0.125f)).apply(Modifiers.setPosition(0.625f)).export(quadMap.get(null));
        } else if (quadDir.m_122434_() == this.dir.m_122427_().m_122434_()) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(false, 0.625f)).apply(Modifiers.cutSideLeftRight(0.5625f)).apply(Modifiers.setPosition(0.9375f)).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(true, 0.125f)).apply(Modifiers.cutSideLeftRight(0.625f)).export(quadMap.get(quadDir));
        } else {
            boolean up = quadDir == Direction.UP;
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir.m_122434_(), 0.5625f)).apply(Modifiers.cutTopBottom(this.dir.m_122427_().m_122434_(), 0.9375f)).applyIf(Modifiers.setPosition(0.625f), up).export(quadMap.get(up ? null : quadDir));
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir.m_122434_(), 0.625f)).applyIf(Modifiers.setPosition(0.125f), !up).export(quadMap.get(up ? quadDir : null));
        }
    }

    @Override
    protected ChunkRenderTypeSet getAdditionalRenderTypes(RandomSource rand, ModelData extraData) {
        return ModelUtils.CUTOUT;
    }

    @Override
    protected void getAdditionalQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState state, RandomSource rand, ModelData data, RenderType renderType) {
        if (renderType == RenderType.m_110463_()) {
            Utils.forAllDirections(dir -> ((List)quadMap.get(dir)).addAll(this.baseModel.getQuads(state, dir, rand, data, renderType)));
        }
    }
}

